﻿using System;

namespace Splitting
{
    class Program
    {
        static void Main(string[] args)
        {
            {
                // Listing 10-59. Dzielenie łańcucha znaków
                string[] strings = Soliloquize();
                string output = String.Join(Environment.NewLine, strings);
                string[] splitStrings = output.Split(
                    new char[] { ' ', '\t', '\r', '\n', ',', '-', ':' });
                bool first = true;
                foreach (string splitBit in splitStrings)
                {
                    if (first)
                    {
                        first = false;
                    }
                    else
                    {
                        Console.Write(", ");
                    }
                    Console.Write(splitBit);
                }
            }

            Console.WriteLine();

            {
                string[] strings = Soliloquize();
                string output = String.Join(Environment.NewLine, strings);

                // Listing 10-60. Eliminacja pustych łańcuchów w wynikach metody String.Split.
                string[] splitStrings = output.Split(
                    new char[] { ' ', '\t', '\r', '\n', ',', '-', ':' },
                    StringSplitOptions.RemoveEmptyEntries);

                bool first = true;
                foreach (string splitBit in splitStrings)
                {
                    if (first)
                    {
                        first = false;
                    }
                    else
                    {
                        Console.Write(", ");
                    }
                    // Listing 10-61. Wymuszanie zapisywania łańcucha małymi literami.
                    Console.Write(splitBit.ToLower());
                }
            }
        }

        private static string[] Soliloquize()
        {
            return new string[] {
                "Być albo nie być - oto jest pytanie.",
                "Kto postępuje godniej: ten, kto biernie",
                "Stoi pod gradem zajadłych strzał losu,",
                "Czy ten, kto stawia opór morzu nieszczęść",
                "I w walce kładzie im kres?" };
        }

    }
}
